/*******************************************************
Filename		:  di_project_table.sql
Release 		:  c2.0
SIR			:  1471
Description		:  create and populate di_project dimension table.
Author			:  Joseph Wilson
Date			:  1/9/2003
Comments		:  modified to rename columns -Ganesh.
			   06/13/03 updated v2.0
		   01/16/04 - SIR 1586 Moved connect string to master install script -JW
	12/24/2006 - added metadata related changes 
	05/28/2007 -- edited all project description columns to 4000 -GT
**********************************************************/

SPOOL di_project_table.log

drop sequence seq_di_project;

create sequence seq_di_project
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_project;

create table di_project 
tablespace storetdata
storage (initial 5M next 5M)
nologging
as select seq_di_project.nextval pk_isn,
TSMPROJ_IS_NUMBER      ,
TSMPROJ_ORG_ID         ,
IDENTIFICATION_CD project_cd,     
NAME   project_name,                
START_DATE          ,   
PLANNED_DURATION    
from storet1.tsmproj;

commit;

alter table di_project
modify pk_isn number not null;

alter table di_project
add constraint pk_project primary key (pk_isn)
using index
tablespace storetindx
storage (initial 3M next 3M);     


alter table di_project add fk_org number(12);

create index dp_project_proj_org_id  on di_project(tsmproj_org_id)
tablespace storetindx
storage (initial 3M next 3M)
nologging;

update di_project proj set fk_org = (
	select org.pk_isn from di_org org where proj.tsmproj_org_id = org.organization_id);

commit;

drop index dp_project_proj_org_id;

create index ipr_isn_orgid on di_project(tsmproj_is_number,tsmproj_org_id)
tablespace storetindx
storage ( initial 3M next 3M)
nologging;

--*****************************************************************
-- Sug altered the table to include new column purpose
--alter table di_project add PURPOSE VARCHAR2(1000 char);
alter table di_project add PURPOSE VARCHAR2(4000 char);

update di_project proj
 set PURPOSE = (select g.description_text
  from storet1.tsmgntxt g
         where g.tsmproj_is_number = proj.tsmproj_is_number
  and g.tsmproj_org_id = proj.tsmproj_org_id
  and g.description_name = 'PURPOSE');
commit;

-- Sug altered the table to include new column study_area
--alter table di_project add STUDY_AREA VARCHAR2(2000 char);
alter table di_project add STUDY_AREA VARCHAR2(4000 char);

update di_project proj
set STUDY_AREA  = (select g.description_text
                  from storet1.tsmgntxt g
                  where g.tsmproj_is_number = proj.tsmproj_is_number
                  and g.tsmproj_org_id = proj.tsmproj_org_id
                  and g.description_name = 'AREADESC');

commit;

--Sug altered the table to include new column Project_Design
--alter table di_project add PROJECT_DESIGN VARCHAR2(2000 char);
alter table di_project add PROJECT_DESIGN VARCHAR2(4000 char);

update di_project proj
set PROJECT_DESIGN  = (select g.description_text 
                      from storet1.tsmgntxt g
                      where g.tsmproj_is_number = proj.tsmproj_is_number
                      and g.tsmproj_org_id = proj.tsmproj_org_id
                      and g.description_name = 'DSGNDESC');
commit;


--Sug altered the table to include new column Obtain_Plan
--alter table di_project add OBTAIN_PLAN VARCHAR2(2000 char);
alter table di_project add OBTAIN_PLAN VARCHAR2(4000 char);

update di_project proj
set OBTAIN_PLAN  = (select g.description_text
                    from storet1.tsmgntxt g
                    where g.tsmproj_is_number = proj.tsmproj_is_number
                    and g.tsmproj_org_id = proj.tsmproj_org_id
                    and g.description_name = 'WORKPLAN');

commit;

--Sug altered the table to include new column Ouality_Assurance
--alter table di_project add QUALITY_ASSURANCE VARCHAR2(2000 char);
alter table di_project add QUALITY_ASSURANCE VARCHAR2(4000 char);

update di_project proj
set QUALITY_ASSURANCE = (select g.description_text
                        from storet1.tsmgntxt g
  			where g.tsmproj_is_number = proj.tsmproj_is_number
  			and g.tsmproj_org_id = proj.tsmproj_org_id
  			and g.description_name = 'QAPPSUMM');

commit;

--Sug altered the table to include new column Ouality_Objectives
--alter table di_project add QUALITY_OBJECTIVES VARCHAR2(2000 char);
alter table di_project add QUALITY_OBJECTIVES VARCHAR2(4000 char);


update di_project proj
set QUALITY_OBJECTIVES = (select g.description_text
                          from storet1.tsmgntxt g
                          where g.tsmproj_is_number = proj.tsmproj_is_number
                          and g.tsmproj_org_id = proj.tsmproj_org_id
                          and g.description_name = 'MSRMNTQL');

commit;
--***********************************************************************************

--drop index dp_project_proj_org_id;

--drop index ipr_isn_orgid;

--**********************************************************************************
/* sug created the index ipr_isn_orgid replaced tsmproj_org_id instead of project_org_id
create index ipr_isn_orgid on di_project(tsmproj_is_number,tsmproj_org_id)
tablespace storetindx
storage ( initial 3M next 3M)
nologging;
*/
-- test defect fix
alter table di_project add blob_title varchar2(256 char);
alter table di_project add blob_id varchar2(256);

update di_project p set blob_title=(select blob_title
     from storet1.tsmproj pj
     where pj.tsmproj_is_number = p.tsmproj_is_number
      and pj.tsmproj_org_id = p.tsmproj_org_id);
commit;

/*  this should be moved to fa_blob creation script.
update di_project p set blob_id = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where fa.tsmproj_is_number = p.tsmproj_is_number
	and fa.tsmproj_org_id = p.tsmproj_org_id)
where p.blob_title is not null;	
commit;
*/

SPOOL OFF